/**
* \file: mlink_wl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* MLINK WL Adapter
*
* \component: mlink
*
* \author: Michael Methner ADITG/SW1 mmethner@de.adit-jv.com
*
* \copyright: (c) 2003 - 2013 ADIT Corporation
*
* \history
* 0.1 Michael Methner Initial version
*
***********************************************************************/


#ifndef _MLINK_WL_H_
#define _MLINK_WL_H_

#ifdef __cplusplus
extern "C"
{
#endif

#define VNC_USE_STDINT_H


#include <vncviewersdk.h>
#include <compositor-shim.h>


#include <mlink_common.h>
#include <dlt/dlt.h>

enum mlink_wl_flags
{
  MLINK_WL_ENABLE_TOUCHEVENTS = 0x1,
};


#define MLINK_WL_MAX_TOUCHPOINTS 2

typedef void mlink_wl_error_callback(mlink_adapter_context * pCtx, char * pMessage);


mlink_wl_context * mlink_wl_initialize(VNCViewerSDK * pViewerSdk,
    VNCViewer *pViewer, DltContext * p_dlt_ctx,
    unsigned int layer_id, unsigned int surface_id,
    VNCPixelFormat * p_framebuffer_pixelformat,
    int screen_x_offset, int screen_y_offset,
    int screen_width, int screen_height, unsigned int force_fullscreen,
    enum mlink_wl_flags flags,
    mlink_wl_error_callback * pErrorCb,
    int is_h264_enabled);

int mlink_connect_to_wayland(mlink_wl_context * p_wl_ctx);

void mlink_wl_finalize(mlink_wl_context * p_ctx);

void mlink_wl_pump_events(mlink_wl_context * p_wl_ctx);

void mlink_wl_enable_multitouch(mlink_wl_context * p_wl_ctx, vnc_int32_t enable);


void
mlink_wl_server_init_callback(VNCViewer *pViewer, void *vpContext, vnc_uint16_t width,
    vnc_uint16_t height, const char *desktopName,
    const VNCPixelFormat *pServerNativePixelFormat);


void
mlink_wl_desktop_resize_callback(VNCViewer *pViewer, void *vpContext, vnc_uint16_t newWidth,
    vnc_uint16_t newHeight);


vnc_uint8_t *
mlink_wl_lock_rectangle_ex_callback(VNCViewer *pViewer, void *vpContext,
    const VNCRectangle *pRectangle, size_t *pStride,
    VNCViewerLockRectangleReason reason);


void
mlink_wl_framebuffer_update_end_callback(VNCViewer *pViewer, void *vpContext,
    const VNCRectangle *pInvalidatedRectangles, size_t rectangleCount);


#ifdef __cplusplus
}
#endif

#endif /* _MLINK_WL_H_ */
